<?php
/**
 * Plugin Name: Auto Redirect Cleaner
 * Description: Analizza e ottimizza i redirect gestiti da Rank Math.
 * Version: 0.5
 * Requires Plugins: seo-by-rank-math
 * Requires at least: 6.0
 * Requires PHP: 7.0
 * Author: Angelo Cicchiello
 * Author URI: https://angelocicchiello.dev
 */

if ( ! defined( 'ABSPATH' ) ) exit; // sicurezza

// Definisci costanti
define( 'ARC_PLUGIN_VERSION', '0.1' );
define( 'ARC_REDIRECT_LOG_TABLE', 'arc_redirect_logs' ); // Nome della tabella per i log

// Carica i file necessari
require_once plugin_dir_path(__FILE__) . 'includes/class-arc-db.php'; // Nuova classe per il DB
require_once plugin_dir_path(__FILE__) . 'includes/class-arc-admin.php';
require_once plugin_dir_path(__FILE__) . 'includes/class-arc-logger.php';
require_once plugin_dir_path(__FILE__) . 'includes/class-arc-analyzer.php';

/**
 * Funzione di attivazione del plugin.
 * Crea la tabella del database per i log dei redirect.
 */
function arc_activate() {
    ARC_DB::init(); // Inizializza il nome della tabella
    ARC_DB::create_log_table();
}
register_activation_hook( __FILE__, 'arc_activate' );

/**
 * Funzione di disinstallazione del plugin.
 * Elimina la tabella del database per i log dei redirect.
 */
function arc_uninstall() {
    ARC_DB::init(); // Inizializza il nome della tabella
    ARC_DB::drop_log_table();
}
register_uninstall_hook( __FILE__, 'arc_uninstall' );

// Inizializza plugin
function arc_init() {
    ARC_DB::init(); // Inizializza il nome della tabella per tutte le classi
    new ARC_Admin(); // ARC_Admin ora crea la sua istanza di ARC_Analyzer
    new ARC_Logger();
    // Rimosso: new ARC_Analyzer(); // Non è più necessario qui
}
add_action('plugins_loaded', 'arc_init');